#ifndef _DBINIT_CPP
#define _DBINIT_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WindowsX.H>
#include <ShellAPI.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <SQL.H>
#include <SQLExt.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"
#include "../../SharedClasses/CRC32/CRC.H"
#include "../../SharedClasses/SQLClass/cSQL.H"
#include "../../SharedClasses/SQLClass/cRecordSet.H"
#include "../../SharedClasses/CGetPKs/CGetPKs.H"
#include "../CSockSrvr/CSockSrvr.H"

#include "../../SharedSource/NSWFL.H"
#include "Init.H"
#include "Entry.H"
#include "Routines.H"
#include "Console.H"
#include "DBInit.H"

#include "../Dialogs/ReplicationDlg.H"
#include "../Dialogs/MainDlg.H"

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool GenerateDBCreationSQL(CSQL *lpCSQL, CSockSrvr *pSockSrvr, int iClient, char *sDB, char *sDBO, char *sTargetFile)
{
	//WriteCon("GenerateDBCreationSQL\n");

	char sText[1024];
	char sSQL[10240];
	int iTempSz = 0;
	int iLen = 0;
	char sTableSQL[10240];
	char sPKSQL[10240];

	char sSmlTmp[32];
	char sType[255];
	char sCol[1024];
	char sPKName[1024];
	char sTable[1024];
	int iColLen = 0;
	int iColStat = 0;
	int iIsPKCol = 0;

	CRecordSet rsTables;
	CRecordSet rsColumns;

	FILE *hTarget = NULL;

	if((hTarget = fopen(sTargetFile, "wb")) == NULL)
	{
		return false;
	}

	//Create a record set containing all of the table names that contain SQLExch_ triggers
	strcpy(sSQL, "SELECT Obj.Name as TableName, PK.Name as PKName"
		" FROM SysObjects as Obj, SysObjects as PK"
		" WHERE Obj.xType = 'U' AND (LEFT(Obj.NAME, 8) <> 'SQLExch_' AND"
		" Obj.ID IN (SELECT Parent_Obj FROM SysObjects AS A WHERE A.xType = 'TR'"
		" AND LEFT(A.NAME, 8) = 'SQLExch_'))"
		" AND PK.Parent_Obj = Obj.ID AND PK.xType = 'PK'"
		" ORDER BY Obj.Name");
	lpCSQL->Execute(sSQL, &rsTables);
	
	fwrite(&rsTables.RowCount, sizeof(rsTables.RowCount), 1, hTarget);

	//Loop through all of the tables that have triggers.
	while(rsTables.Fetch())
	{
		//Get the table name, save it in sTable[]
		rsTables.sColumnEx(1, sTable, sizeof(sTable), &iTempSz);
		//Get the PK name, save it in sPKName[]
		rsTables.sColumnEx(2, sPKName, sizeof(sPKName), &iTempSz);

		sprintf(sText, "Generating SQL for %s", sTable);
		WriteLog(pSockSrvr->icClientID[iClient], sText);

		sprintf(sSQL, "SELECT SysColumns.Name, SysTypes.Name, SysColumns.Length, SysTypes.Status as TypeStatus,"
			" IsNull((SELECT 1 FROM SysObjects, SysIndexes, SysIndexKeys"
			" WHERE SysObjects.xtype = 'PK' AND SysObjects.Name = SysIndexes.Name AND SysIndexes.IndId = SysIndexKeys.IndId"
			" AND SysIndexes.ID = SysIndexKeys.ID AND SysIndexKeys.ColId = SysColumns.ColId"
			" AND SysObjects.Parent_Obj = SysColumns.ID AND SysObjects.Parent_Obj = SysColumns.ID), 0) as IsPK"
			" FROM SysColumns, SysTypes"
			" WHERE SysColumns.ID = Object_ID('%s') AND SysColumns.xType = SysTypes.xUserType"
			" ORDER BY SysColumns.ColOrder", sTable);
		lpCSQL->Execute(sSQL, &rsColumns);
			
		sprintf(sTableSQL, "CREATE TABLE [{SQLExch_TAG_DB}].[DBO].[%s] (\r\n", sTable);

		sprintf(sPKSQL, "\tCONSTRAINT [");
		strcat(sPKSQL, sPKName);
		strcat(sPKSQL, "] PRIMARY KEY CLUSTERED\r\n");
		strcat(sPKSQL, "\t(\r\n");

		while(rsColumns.Fetch())
		{
			//Get the column name, save it in sCol[]
			rsColumns.sColumnEx(1, sCol, sizeof(sCol), &iTempSz);

			//Get the type name, save it in sType[]
			rsColumns.sColumnEx(2, sType, sizeof(sType), &iTempSz);

			//Get the column length.
			iColLen = rsColumns.lColumn(3);

			//Get the column type status.
			iColStat = rsColumns.lColumn(4);

			//Get the Is PK column flag.
			iIsPKCol = rsColumns.lColumn(5);

			strcat(sTableSQL, "\t[");
			strcat(sTableSQL, sCol);
			strcat(sTableSQL, "] ");

			strcat(sTableSQL, sType);

			if(iColStat != 0)
			{
				sprintf(sSmlTmp, " (%d)", iColLen);
				strcat(sTableSQL, sSmlTmp);
			}

			if(iIsPKCol > 0)
			{
				strcat(sPKSQL, "\t\t[");
				strcat(sPKSQL, sCol);
				strcat(sPKSQL, "],\r\n");
				strcat(sTableSQL, " NOT NULL,\r\n");
			}
			else{
				strcat(sTableSQL, " NULL,\r\n");
			}
		}

		sPKSQL[strlen(sPKSQL) - 3] = '\0';
		sTableSQL[strlen(sTableSQL) - 3] = '\0';

		strcat(sPKSQL, "\r\n\t) ON [PRIMARY]");

		strcat(sTableSQL, "\r\n");
		strcat(sTableSQL, sPKSQL);
		strcat(sTableSQL, "\r\n");

		strcat(sTableSQL, ") ON [PRIMARY]\r\n");

		rsColumns.Close();

		//Write Table Name.
		iLen = strlen(sTable);
		fwrite(&iLen, sizeof(iLen), 1, hTarget);
		fwrite(sTable, sizeof(char), iLen, hTarget);

		//Write PK Name.
		iLen = strlen(sPKName);
		fwrite(&iLen, sizeof(iLen), 1, hTarget);
		fwrite(sPKName, sizeof(char), iLen, hTarget);

		//Write SQL.
		iLen = strlen(sTableSQL);
		fwrite(&iLen, sizeof(iLen), 1, hTarget);
		fwrite(sTableSQL, sizeof(char), iLen, hTarget);
	}	
	
	fclose(hTarget);

	rsTables.Close();

	return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
